
# Card

Represents the payment details of a card to be used for payments. These
details are determined by the payment token generated by Web Payments SDK.

## Structure

`Card`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `id` | `?string` | Optional | Unique ID for this card. Generated by Square.<br>**Constraints**: *Maximum Length*: `64` | getId(): ?string | setId(?string id): void |
| `cardBrand` | [`?string (CardBrand)`](/doc/models/card-brand.md) | Optional | Indicates a card's brand, such as `VISA` or `MASTERCARD`. | getCardBrand(): ?string | setCardBrand(?string cardBrand): void |
| `last4` | `?string` | Optional | The last 4 digits of the card number.<br>**Constraints**: *Maximum Length*: `4` | getLast4(): ?string | setLast4(?string last4): void |
| `expMonth` | `?int` | Optional | The expiration month of the associated card as an integer between 1 and 12. | getExpMonth(): ?int | setExpMonth(?int expMonth): void |
| `expYear` | `?int` | Optional | The four-digit year of the card's expiration date. | getExpYear(): ?int | setExpYear(?int expYear): void |
| `cardholderName` | `?string` | Optional | The name of the cardholder.<br>**Constraints**: *Maximum Length*: `96` | getCardholderName(): ?string | setCardholderName(?string cardholderName): void |
| `billingAddress` | [`?Address`](/doc/models/address.md) | Optional | Represents a postal address in a country. The address format is based<br>on an [open-source library from Google](https://github.com/google/libaddressinput). For more information,<br>see [AddressValidationMetadata](https://github.com/google/libaddressinput/wiki/AddressValidationMetadata).<br>This format has dedicated fields for four address components: postal code,<br>locality (city), administrative district (state, prefecture, or province), and<br>sublocality (town or village). These components have dedicated fields in the<br>`Address` object because software sometimes behaves differently based on them.<br>For example, sales tax software may charge different amounts of sales tax<br>based on the postal code, and some software is only available in<br>certain states due to compliance reasons.<br><br>For the remaining address components, the `Address` type provides the<br>`address_line_1` and `address_line_2` fields for free-form data entry.<br>These fields are free-form because the remaining address components have<br>too many variations around the world and typical software does not parse<br>these components. These fields enable users to enter anything they want.<br><br>Note that, in the current implementation, all other `Address` type fields are blank.<br>These include `address_line_3`, `sublocality_2`, `sublocality_3`,<br>`administrative_district_level_2`, `administrative_district_level_3`,<br>`first_name`, `last_name`, and `organization`.<br><br>When it comes to localization, the seller's language preferences<br>(see [Language preferences](https://developer.squareup.com/docs/locations-api#location-specific-and-seller-level-language-preferences))<br>are ignored for addresses. Even though Square products (such as Square Point of Sale<br>and the Seller Dashboard) mostly use a seller's language preference in<br>communication, when it comes to addresses, they will use English for a US address,<br>Japanese for an address in Japan, and so on. | getBillingAddress(): ?Address | setBillingAddress(?Address billingAddress): void |
| `fingerprint` | `?string` | Optional | __Not currently set.__ Intended as a Square-assigned identifier, based<br>on the card number, to identify the card across multiple locations within a<br>single application.<br>**Constraints**: *Maximum Length*: `255` | getFingerprint(): ?string | setFingerprint(?string fingerprint): void |
| `customerId` | `?string` | Optional | The ID of a customer created using the Customers API to be associated with the card. | getCustomerId(): ?string | setCustomerId(?string customerId): void |
| `referenceId` | `?string` | Optional | An optional user-defined reference ID that associates this card with<br>another entity in an external system. For example, a customer ID from an<br>external customer management system.<br>**Constraints**: *Maximum Length*: `128` | getReferenceId(): ?string | setReferenceId(?string referenceId): void |
| `enabled` | `?bool` | Optional | Indicates whether or not a card can be used for payments. | getEnabled(): ?bool | setEnabled(?bool enabled): void |
| `cardType` | [`?string (CardType)`](/doc/models/card-type.md) | Optional | Indicates a card's type, such as `CREDIT` or `DEBIT`. | getCardType(): ?string | setCardType(?string cardType): void |
| `prepaidType` | [`?string (CardPrepaidType)`](/doc/models/card-prepaid-type.md) | Optional | Indicates a card's prepaid type, such as `NOT_PREPAID` or `PREPAID`. | getPrepaidType(): ?string | setPrepaidType(?string prepaidType): void |
| `bin` | `?string` | Optional | The first six digits of the card number, known as the Bank Identification Number (BIN). Only the Payments API<br>returns this field.<br>**Constraints**: *Maximum Length*: `6` | getBin(): ?string | setBin(?string bin): void |
| `version` | `?int` | Optional | Current version number of the card. Increments with each card update. Requests to update an<br>existing Card object will be rejected unless the version in the request matches the current<br>version for the Card. | getVersion(): ?int | setVersion(?int version): void |

## Example (as JSON)

```json
{
  "id": "id0",
  "card_brand": "OTHER_BRAND",
  "last_4": "last_42",
  "exp_month": 42,
  "exp_year": 254
}
```

